/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.net;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import jeus.util.CUtility;
import jeus.util.cnet.SocketProxy;
import jeus.util.concurrent50.concurrent.Executor;
import jeus.util.message.JeusMessage_Network;
import jeus.util.net.Dispatcher;
import jeus.util.net.JeusNetUtil;
import jeus.util.net.JeusTransceiver;
import jeus.util.net.PassiveReceiverTable;
import jeus.util.net.PipeServerSocket;
import jeus.util.net.PipeSocket;
import jeus.util.net.SocketDispatcher;
import jeus.util.net.SocketDispatcherListener;
import jeus.util.net.VirtualListener;

public class PassiveDispatcher
extends SocketDispatcher {
    private String pipeName;
    private SocketChannel transSocketChannel;
    private boolean running;
    private boolean pipeSupported;
    private PipeServerSocket pserver;
    private int pPid = CUtility.thisProcessPID;
    private JeusTransceiver jtrans;

    public PassiveDispatcher(Executor executor, int listenport, SocketDispatcherListener listener) throws IOException {
        super(executor, listenport, listener);
        this.receiverTable = new PassiveReceiverTable(this.getDispatcherName());
        this.pipeSupported = JeusNetUtil.pipeSupported;
        if (this.pipeSupported) {
            this.pipeName = "JPIPE_" + CUtility.thisProcessPID;
        }
        this.initSocket();
        this.running = true;
        this.thread = new Thread(this);
        this.thread.setName("PassiveDispatcher-" + listenport);
        this.thread.start();
        if (logger.isLoggable(JeusMessage_Network._1015_LEVEL)) {
            logger.log(JeusMessage_Network._1015_LEVEL, JeusMessage_Network._1015);
        }
    }

    protected String getDispatcherName() {
        return "<PassiveDispatcher>";
    }

    public void destroy() {
        this.running = false;
        try {
            if (this.pserver != null) {
                this.pserver.close();
                File f = new File(this.pserver.getPath());
                f.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initSocket() throws IOException {
        this.transSocketChannel = SocketChannel.open();
        this.transSocketChannel.configureBlocking(true);
        try {
            this.transSocketChannel.connect(new InetSocketAddress("localhost", this.listenport));
        }
        catch (UnresolvedAddressException ex) {
            IOException e = new IOException("cannot resolve address 'localhost', maybe the localhost is not registered in hosts file");
            e.initCause(ex);
            throw e;
        }
        Socket transSocket = this.transSocketChannel.socket();
        if (this.pipeSupported) {
            this.pserver = new PipeServerSocket(this.pipeName);
        }
        byte opcode = 97;
        byte[] buf = SocketProxy.makePacket(opcode, this.pPid + "");
        ByteBuffer b = ByteBuffer.wrap(buf);
        this.transSocketChannel.write(b);
        if (this.pipeSupported) {
            PipeSocket pTransSocket = this.pserver.accept();
            if (pTransSocket != null) {
                this.jtrans = new JeusTransceiver(pTransSocket, -1);
            }
        } else {
            this.jtrans = new JeusTransceiver(transSocket, -1);
        }
        byte[] replyArr = new byte[1];
        this.transSocketChannel.read(ByteBuffer.wrap(replyArr));
        byte reply = replyArr[0];
        if (reply != 111) {
            throw new IOException("<PassiveDispatcher> (passive-mode) init failed. invalid reponse : " + String.valueOf(reply));
        }
        if (logger.isLoggable(JeusMessage_Network._1016_LEVEL)) {
            logger.log(JeusMessage_Network._1016_LEVEL, JeusMessage_Network._1016, (Object)String.valueOf(this.listenport));
        }
    }

    public Object register(VirtualListener event) throws IOException {
        Integer port = (Integer)super.register(event);
        String id = event.getId();
        String body = id + ":" + port;
        byte[] buf = SocketProxy.makePacket((byte)98, body);
        this.transSocketChannel.write(ByteBuffer.wrap(buf));
        return port;
    }

    public void unregister(VirtualListener event) {
        String id = event.getId();
        try {
            byte[] buf = SocketProxy.makePacket((byte)99, id);
            this.transSocketChannel.write(ByteBuffer.wrap(buf));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.unregister(event);
    }

    public void run() {
        while (this.running) {
            try {
                int rid = this.jtrans.receive();
                if (!this.running) break;
                Integer id = new Integer(rid);
                VirtualListener r = (VirtualListener)this.receiverTable.get(id);
                SocketChannel ch = this.jtrans.getNewSocketChannel();
                Socket socket = ch.socket();
                if (r == null) {
                    if (logger.isLoggable(JeusMessage_Network._1019_LEVEL)) {
                        logger.log(JeusMessage_Network._1019_LEVEL, JeusMessage_Network._1019, (Object)id);
                    }
                    this.closeSocket(socket);
                    continue;
                }
                if (logger.isLoggable(JeusMessage_Network._1018_LEVEL)) {
                    logger.log(JeusMessage_Network._1018_LEVEL, JeusMessage_Network._1018, new Object[]{socket, r.getId()});
                }
                this.executor.execute(new Dispatcher(r, socket));
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                if (!this.running) continue;
                this.listener.failover(ioe, this);
            }
        }
    }

    private void closeSocket(Socket socket) {
        try {
            socket.shutdownInput();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            socket.shutdownOutput();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

