/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.net;

import java.io.IOException;
import java.io.InputStream;
import jeus.util.net.PipeSocketImpl;

class PipeInputStream
extends InputStream {
    private PipeSocketImpl impl;
    private int fd;
    private boolean eof;
    private byte[] temp;

    PipeInputStream(PipeSocketImpl impl) throws IOException {
        this.impl = impl;
        this.fd = impl.getFileDescriptor();
    }

    private native int pipeRead(byte[] var1, int var2, int var3, int var4, int var5) throws IOException;

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.eof) {
            return -1;
        }
        int n = this.pipeRead(b, off, len, this.fd, this.impl.getTimeout());
        if (n < 0) {
            this.eof = true;
            return -1;
        }
        return n;
    }

    public int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        this.temp = new byte[1];
        int n = this.read(this.temp, 0, 1);
        if (n < 0) {
            this.eof = true;
            return -1;
        }
        return this.temp[0] & 0xFF;
    }
}

