/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.net;

import java.io.File;
import java.io.IOException;
import jeus.util.net.JeusNetUtil;
import jeus.util.net.PipeSocket;
import jeus.util.net.PipeSocketImpl;

public class PipeServerSocket {
    private PipeSocketImpl impl;
    private String path;
    private int backlog;

    public PipeServerSocket(String path, int backlog) throws IOException {
        if (!JeusNetUtil.pipeSupported) {
            throw new IllegalStateException("UNIX domain socket not supported in this platform");
        }
        this.path = path;
        this.backlog = backlog;
        if (!path.startsWith(File.separator)) {
            this.path = JeusNetUtil.jeusPipePath + path;
        } else {
            File f = new File(path).getParentFile();
            if (!f.exists()) {
                f.mkdirs();
            }
            this.path = path;
        }
        this.impl = new PipeSocketImpl(this.path);
        this.impl.listen(backlog);
    }

    public PipeServerSocket(String path) throws IOException {
        this(path, 50);
    }

    public String getPath() {
        return this.path;
    }

    public PipeSocket accept() throws IOException {
        return this.impl.accept();
    }

    public void close() throws IOException {
        this.impl.close();
    }

    public int getfd() {
        if (this.impl == null) {
            throw new IllegalStateException("PipeServerSocket impl is null");
        }
        return this.impl.getFileDescriptor();
    }

    public String toString() {
        return "PipeServerSocket(" + this.path + ")";
    }
}

