/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import jeus.util.net.JeusFileDescriptor;
import jeus.util.net.JeusNetUtil;
import jeus.util.net.PipeInputStream;
import jeus.util.net.PipeOutputStream;
import jeus.util.net.PipeSocket;

public class PipeSocketImpl {
    private String path;
    private JeusFileDescriptor fd;
    private int listenfd;
    private int timeout;

    private native int pipeConnect(String var1) throws IOException;

    private native int pipeListen(String var1, int var2) throws IOException;

    private native int pipeAccept(int var1) throws IOException;

    private native void pipeClose(int var1) throws IOException;

    private native void setsockopt(int var1, int var2, Object var3) throws SocketException;

    private native Object getsockopt(int var1, int var2) throws SocketException;

    static native boolean isBigEndian();

    static native String getenv(String var0);

    public PipeSocketImpl(String path) {
        this.path = path;
        this.fd = new JeusFileDescriptor(-1);
    }

    private PipeSocketImpl(String path, JeusFileDescriptor fdesc) {
        this.path = path;
        this.fd = fdesc;
    }

    public void connect() throws IOException {
        this.fd = new JeusFileDescriptor(this.pipeConnect(this.path));
        if (this.fd == null || this.fd.getFileDescriptor() <= 0) {
            throw new IOException("socket(" + this.path + ") connect failed");
        }
    }

    public void listen(int backlog) throws IOException {
        this.fd = new JeusFileDescriptor(this.pipeListen(this.path, backlog));
        if (this.fd == null || this.fd.getFileDescriptor() <= 0) {
            throw new IOException("socket(" + this.path + ") listen failed");
        }
        this.listenfd = this.fd.getFileDescriptor();
    }

    public PipeSocket accept() throws IOException {
        int cfd = this.pipeAccept(this.listenfd);
        if (cfd <= 0) {
            throw new IOException("socket(" + this.path + ") accept failed");
        }
        PipeSocketImpl client = new PipeSocketImpl(this.path, new JeusFileDescriptor(cfd));
        return new PipeSocket(this.path, client);
    }

    public InputStream getInputStream() throws IOException {
        return new PipeInputStream(this);
    }

    public OutputStream getOutputStream() throws IOException {
        return new PipeOutputStream(this.fd.getFileDescriptor());
    }

    public void setOption(int optname, Object val) throws SocketException {
        switch (optname) {
            case 4102: {
                this.timeout = (Integer)val;
                break;
            }
            case 4097: {
                this.setsockopt(this.fd.getFileDescriptor(), 4097, val);
                break;
            }
            default: {
                throw new SocketException("unsupported pipe socket option : " + String.valueOf(optname));
            }
        }
    }

    public Object getOption(int optname) throws SocketException {
        switch (optname) {
            case 4102: {
                return new Integer(this.timeout);
            }
            case 4097: {
                return this.getsockopt(this.fd.getFileDescriptor(), 4097);
            }
        }
        throw new SocketException("unsupported pipe socket option : " + String.valueOf(optname));
    }

    public int getFileDescriptor() {
        if (this.fd == null) {
            return -1;
        }
        return this.fd.getFileDescriptor();
    }

    public void close() throws IOException {
        if (this.fd != null) {
            this.pipeClose(this.fd.getFileDescriptor());
            this.fd.setFileDescriptor(-1);
            this.fd = null;
        }
    }

    int getTimeout() {
        return this.timeout;
    }

    public String toString() {
        return "unix(" + this.path + " " + this.fd + ")";
    }

    static {
        boolean bl = JeusNetUtil.pipeSupported;
    }
}

