/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.net;

import java.io.IOException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Network;
import jeus.util.net.DispatcherRequestHandler;
import jeus.util.net.JNBBuffer;
import jeus.util.net.ReceiverTable;
import jeus.util.net.VirtualListener;

class UnregRequestHandler
extends DispatcherRequestHandler {
    private ReceiverTable receiverTable;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.netutil");

    UnregRequestHandler(ReceiverTable rt, String dispatcherName) {
        this.dispatcherName = dispatcherName;
        this.receiverTable = rt;
    }

    void handleRequest(JNBBuffer buf) throws IOException {
        String id = buf.getBodyString();
        VirtualListener r = (VirtualListener)this.receiverTable.get(id);
        if (r == null) {
            if (logger.isLoggable(JeusMessage_Network._1025_LEVEL)) {
                logger.log(JeusMessage_Network._1025_LEVEL, JeusMessage_Network._1025, new Object[]{this.dispatcherName, id});
            }
        } else {
            this.receiverTable.unregister(r);
            buf.removeId(id);
            if (logger.isLoggable(JeusMessage_Network._1026_LEVEL)) {
                logger.log(JeusMessage_Network._1026_LEVEL, JeusMessage_Network._1026, new Object[]{this.dispatcherName, id});
            }
        }
    }
}

