/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.scheduler;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import jeus.util.scheduler.ScheduleTask;
import jeus.util.scheduler.ScheduledExecutor;

public class ScheduledExecutorFor5
extends ScheduledExecutor {
    private ScheduledExecutorService scheduledExecutor;

    private synchronized ScheduledExecutorService getScheduledExecutor() {
        if (this.scheduledExecutor == null || this.scheduledExecutor.isShutdown()) {
            this.scheduledExecutor = Executors.newScheduledThreadPool(2, new DaemonThreadFactory("SchedulingService"));
        }
        return this.scheduledExecutor;
    }

    public void remove(Object obj) {
        ScheduledFuture future = (ScheduledFuture)obj;
        if (future.cancel(false) && this.scheduledExecutor instanceof ScheduledThreadPoolExecutor) {
            ((ScheduledThreadPoolExecutor)this.scheduledExecutor).remove((Runnable)((Object)future));
        }
    }

    public void remove(ScheduleTask future) {
        this.remove(future.getFuture());
    }

    public Object schedule(Runnable command, long delay, TimeUnit unit) {
        return this.getScheduledExecutor().schedule(command, delay, unit);
    }

    public Object scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.getScheduledExecutor().scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public Object scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.getScheduledExecutor().scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    public Object schedule(ScheduleTask command, long delay) {
        ScheduledFuture future = (ScheduledFuture)this.schedule(command, delay, TimeUnit.MILLISECONDS);
        command.setSchedulerExecutor(this);
        command.setFuture(future);
        return future;
    }

    public Object scheduleWithFixedDelay(ScheduleTask command, long initialDelay, long delay) {
        ScheduledFuture future = (ScheduledFuture)this.scheduleWithFixedDelay(command, initialDelay, delay, TimeUnit.MILLISECONDS);
        command.setSchedulerExecutor(this);
        command.setFuture(future);
        return future;
    }

    public Object scheduleAtFixedRate(ScheduleTask command, long initialDelay, long period) {
        ScheduledFuture future = (ScheduledFuture)this.scheduleAtFixedRate(command, initialDelay, period, TimeUnit.MILLISECONDS);
        command.setSchedulerExecutor(this);
        command.setFuture(future);
        return future;
    }

    public synchronized void cancelAll() {
        if (this.scheduledExecutor != null && !this.scheduledExecutor.isShutdown()) {
            this.scheduledExecutor.shutdown();
            this.scheduledExecutor = null;
        }
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        final String namePrefix;
        final AtomicInteger threadNumber = new AtomicInteger(1);

        public DaemonThreadFactory(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, this.namePrefix + "-" + this.threadNumber.getAndIncrement());
            t.setDaemon(true);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

