/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.mojos;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.archive.AssemblyArchiver;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.io.AssemblyReadException;
import org.apache.maven.plugin.assembly.io.AssemblyReader;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.utils.AssemblyFormatUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

public abstract class AbstractAssemblyMojo
extends AbstractMojo
implements AssemblerConfigurationSource {
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private List reactorProjects;
    private File outputDirectory;
    private String finalName;
    private File workDirectory;
    private String classifier;
    private File[] descriptors;
    private String[] descriptorRefs;
    private File descriptorSourceDirectory;
    private File archiveBaseDirectory;
    protected String descriptorId;
    protected File descriptor;
    private String tarLongFileMode;
    private File basedir;
    private MavenProjectHelper projectHelper;
    private File tempRoot;
    private File siteDirectory;
    private boolean includeSite;
    protected boolean appendAssemblyId;
    private MavenArchiveConfiguration archive;
    protected List filters;
    private boolean attach;
    private AssemblyArchiver assemblyArchiver;
    private AssemblyReader assemblyReader;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List assemblies;
        try {
            assemblies = this.assemblyReader.readAssemblies(this);
        }
        catch (AssemblyReadException e) {
            throw new MojoExecutionException("Error reading assemblies: " + e.getMessage(), (Exception)e);
        }
        catch (InvalidAssemblerConfigurationException e) {
            throw new MojoFailureException((Object)this.assemblyReader, e.getMessage(), "Mojo configuration is invalid: " + e.getMessage());
        }
        Iterator assemblyIterator = assemblies.iterator();
        while (assemblyIterator.hasNext()) {
            Assembly assembly = (Assembly)assemblyIterator.next();
            try {
                String fullName = AssemblyFormatUtils.getDistributionName(assembly, this);
                Iterator formatIterator = assembly.getFormats().iterator();
                while (formatIterator.hasNext()) {
                    String format = (String)formatIterator.next();
                    File destFile = this.assemblyArchiver.createArchive(assembly, fullName, format, this);
                    MavenProject project = this.getProject();
                    String classifier = this.getClassifier();
                    if (!this.attach || !destFile.isFile()) continue;
                    if (this.isAssemblyIdAppended()) {
                        this.projectHelper.attachArtifact(project, format, assembly.getId(), destFile);
                        continue;
                    }
                    if (classifier != null) {
                        this.projectHelper.attachArtifact(project, format, classifier, destFile);
                        continue;
                    }
                    this.projectHelper.attachArtifact(project, format, null, destFile);
                }
            }
            catch (ArchiveCreationException e) {
                throw new MojoExecutionException("Failed to create assembly: " + e.getMessage(), (Exception)e);
            }
            catch (AssemblyFormattingException e) {
                throw new MojoExecutionException("Failed to create assembly: " + e.getMessage(), (Exception)e);
            }
            catch (InvalidAssemblerConfigurationException e) {
                throw new MojoFailureException((Object)assembly, "Assembly is incorrectly configured: " + assembly.getId(), "Assembly: " + assembly.getId() + " is not configured correctly: " + e.getMessage());
            }
        }
    }

    protected AssemblyArchiver getAssemblyArchiver() {
        return this.assemblyArchiver;
    }

    protected AssemblyReader getAssemblyReader() {
        return this.assemblyReader;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public File getDescriptor() {
        return this.descriptor;
    }

    public String getDescriptorId() {
        return this.descriptorId;
    }

    public String[] getDescriptorReferences() {
        return this.descriptorRefs;
    }

    public File getDescriptorSourceDirectory() {
        return this.descriptorSourceDirectory;
    }

    public File[] getDescriptors() {
        return this.descriptors;
    }

    public abstract MavenProject getProject();

    public File getSiteDirectory() {
        return this.siteDirectory;
    }

    public boolean isSiteIncluded() {
        return this.includeSite;
    }

    public String getFinalName() {
        return this.finalName;
    }

    public boolean isAssemblyIdAppended() {
        return this.appendAssemblyId;
    }

    public String getTarLongFileMode() {
        return this.tarLongFileMode;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public MavenArchiveConfiguration getJarArchiveConfiguration() {
        return this.archive;
    }

    public File getWorkingDirectory() {
        return this.workDirectory;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public File getTemporaryRootDirectory() {
        return this.tempRoot;
    }

    public File getArchiveBaseDirectory() {
        return this.archiveBaseDirectory;
    }

    public List getFilters() {
        return this.filters;
    }

    public List getReactorProjects() {
        return this.reactorProjects;
    }

    public String getClassifier() {
        return null;
    }

    protected MavenProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    public void setAppendAssemblyId(boolean appendAssemblyId) {
        this.appendAssemblyId = appendAssemblyId;
    }

    public void setArchive(MavenArchiveConfiguration archive) {
        this.archive = archive;
    }

    public void setArchiveBaseDirectory(File archiveBaseDirectory) {
        this.archiveBaseDirectory = archiveBaseDirectory;
    }

    public void setAssemblyArchiver(AssemblyArchiver assemblyArchiver) {
        this.assemblyArchiver = assemblyArchiver;
    }

    public void setAssemblyReader(AssemblyReader assemblyReader) {
        this.assemblyReader = assemblyReader;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public void setDescriptor(File descriptor) {
        this.descriptor = descriptor;
    }

    public void setDescriptorId(String descriptorId) {
        this.descriptorId = descriptorId;
    }

    public void setDescriptorRefs(String[] descriptorRefs) {
        this.descriptorRefs = descriptorRefs;
    }

    public void setDescriptors(File[] descriptors) {
        this.descriptors = descriptors;
    }

    public void setDescriptorSourceDirectory(File descriptorSourceDirectory) {
        this.descriptorSourceDirectory = descriptorSourceDirectory;
    }

    public void setFilters(List filters) {
        this.filters = filters;
    }

    public void setFinalName(String finalName) {
        this.finalName = finalName;
    }

    public void setIncludeSite(boolean includeSite) {
        this.includeSite = includeSite;
    }

    public void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setProjectHelper(MavenProjectHelper projectHelper) {
        this.projectHelper = projectHelper;
    }

    public void setReactorProjects(List reactorProjects) {
        this.reactorProjects = reactorProjects;
    }

    public void setSiteDirectory(File siteDirectory) {
        this.siteDirectory = siteDirectory;
    }

    public void setTarLongFileMode(String tarLongFileMode) {
        this.tarLongFileMode = tarLongFileMode;
    }

    public void setTempRoot(File tempRoot) {
        this.tempRoot = tempRoot;
    }

    public void setWorkDirectory(File workDirectory) {
        this.workDirectory = workDirectory;
    }

    public List getRemoteRepositories() {
        return this.remoteRepositories;
    }
}

