/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.war.overlay;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.war.Overlay;
import org.apache.maven.plugin.war.overlay.DefaultOverlay;
import org.apache.maven.plugin.war.overlay.InvalidOverlayConfigurationException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

public class OverlayManager {
    private final List overlays = new ArrayList();
    private final MavenProject project;
    private final List artifactsOverlays;

    public OverlayManager(List overlays, MavenProject project, String defaultIncludes, String defaultExcludes) throws InvalidOverlayConfigurationException {
        if (overlays != null) {
            this.overlays.addAll(overlays);
        }
        this.project = project;
        this.artifactsOverlays = this.getOverlaysAsArtifacts();
        this.initialize(defaultIncludes, defaultExcludes);
    }

    public List getOverlays() {
        return this.overlays;
    }

    public List getOverlayIds() {
        Iterator it = this.overlays.iterator();
        ArrayList<String> result = new ArrayList<String>();
        while (it.hasNext()) {
            Overlay overlay = (Overlay)it.next();
            result.add(overlay.getId());
        }
        return result;
    }

    void initialize(String defaultIncludes, String defaultExcludes) throws InvalidOverlayConfigurationException {
        Artifact artifact;
        ArrayList<Artifact> configuredWarArtifacts = new ArrayList<Artifact>();
        ListIterator<Overlay> it = this.overlays.listIterator();
        while (it.hasNext()) {
            Overlay overlay = (Overlay)it.next();
            if (overlay == null) {
                throw new InvalidOverlayConfigurationException("overlay could not be null.");
            }
            if (overlay.isCurrentProject()) {
                overlay = Overlay.currentProjectInstance();
                it.set(overlay);
            }
            if (Overlay.DEFAULT_INCLUDES.equals(overlay.getIncludes()) && Overlay.DEFAULT_EXCLUDES.equals(overlay.getExcludes())) {
                overlay.setIncludes(defaultIncludes);
                overlay.setExcludes(defaultExcludes);
            }
            if ((artifact = this.getAssociatedArtifact(overlay)) == null) continue;
            configuredWarArtifacts.add(artifact);
            overlay.setArtifact(artifact);
        }
        Iterator it2 = this.artifactsOverlays.iterator();
        while (it2.hasNext()) {
            artifact = (Artifact)it2.next();
            if (configuredWarArtifacts.contains(artifact)) continue;
            this.overlays.add(new DefaultOverlay(artifact, defaultIncludes, defaultExcludes));
        }
        Iterator it3 = this.overlays.iterator();
        while (it3.hasNext()) {
            Overlay overlay = (Overlay)it3.next();
            if (!overlay.equals(Overlay.currentProjectInstance())) continue;
            return;
        }
        this.overlays.add(0, Overlay.currentProjectInstance());
    }

    Artifact getAssociatedArtifact(Overlay overlay) throws InvalidOverlayConfigurationException {
        if (overlay.isCurrentProject()) {
            return null;
        }
        Iterator iterator = this.artifactsOverlays.iterator();
        while (iterator.hasNext()) {
            Artifact artifact = (Artifact)iterator.next();
            if (!this.compareOverlayWithArtifact(overlay, artifact)) continue;
            return artifact;
        }
        Set projectArtifacts = this.project.getDependencyArtifacts();
        if (projectArtifacts != null) {
            Iterator iterator2 = projectArtifacts.iterator();
            while (iterator2.hasNext()) {
                Artifact artifact = (Artifact)iterator2.next();
                if (!this.compareOverlayWithArtifact(overlay, artifact)) continue;
                return artifact;
            }
        }
        throw new InvalidOverlayConfigurationException("overlay[" + overlay + "] is not a dependency of the project.");
    }

    private boolean compareOverlayWithArtifact(Overlay overlay, Artifact artifact) {
        return StringUtils.equals((String)overlay.getGroupId(), (String)artifact.getGroupId()) && StringUtils.equals((String)overlay.getArtifactId(), (String)artifact.getArtifactId()) && StringUtils.equals((String)overlay.getType(), (String)artifact.getType()) && (overlay.getClassifier() == null || StringUtils.equals((String)overlay.getClassifier(), (String)artifact.getClassifier()));
    }

    private List getOverlaysAsArtifacts() {
        ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
        Set artifacts = this.project.getArtifacts();
        Iterator it = artifacts.iterator();
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            if (artifact.isOptional() || !filter.include(artifact) || !"war".equals(artifact.getType())) continue;
            result.add(artifact);
        }
        return result;
    }
}

