/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.war.packaging;

import java.io.File;
import java.io.IOException;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.war.Overlay;
import org.apache.maven.plugin.war.packaging.AbstractWarPackagingTask;
import org.apache.maven.plugin.war.packaging.WarPackagingContext;
import org.apache.maven.plugin.war.util.PathSet;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.ManifestException;

public class ClassesPackagingTask
extends AbstractWarPackagingTask {
    public void performPackaging(WarPackagingContext context) throws MojoExecutionException {
        File webappClassesDirectory = new File(context.getWebappDirectory(), "WEB-INF/classes/");
        if (!webappClassesDirectory.exists()) {
            webappClassesDirectory.mkdirs();
        }
        if (context.getClassesDirectory().exists() && !context.getClassesDirectory().equals(webappClassesDirectory)) {
            if (context.archiveClasses()) {
                this.generateJarArchive(context);
            } else {
                PathSet sources = this.getFilesToIncludes(context.getClassesDirectory(), null, null);
                try {
                    this.copyFiles(Overlay.currentProjectInstance().getId(), context, context.getClassesDirectory(), sources, "WEB-INF/classes/");
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Could not copy webapp classes[" + context.getClassesDirectory().getAbsolutePath() + "]", (Exception)e);
                }
            }
        }
    }

    protected void generateJarArchive(WarPackagingContext context) throws MojoExecutionException {
        String archiveName = context.getProject().getBuild().getFinalName() + ".jar";
        String targetFilename = "WEB-INF/lib/" + archiveName;
        if (context.getWebappStructure().registerFile(Overlay.currentProjectInstance().getId(), targetFilename)) {
            File libDirectory = new File(context.getWebappDirectory(), "WEB-INF/lib/");
            File jarFile = new File(libDirectory, archiveName);
            try {
                MavenArchiver archiver = new MavenArchiver();
                archiver.setArchiver(context.getJarArchiver());
                archiver.setOutputFile(jarFile);
                archiver.getArchiver().addDirectory(context.getClassesDirectory(), context.getWebappSourceIncludes(), context.getWebappSourceExcludes());
                archiver.createArchive(context.getProject(), context.getArchive());
            }
            catch (ArchiverException e) {
                throw new MojoExecutionException("Could not create classes archive", (Exception)((Object)e));
            }
            catch (ManifestException e) {
                throw new MojoExecutionException("Could not create classes archive", (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not create classes archive", (Exception)e);
            }
            catch (DependencyResolutionRequiredException e) {
                throw new MojoExecutionException("Could not create classes archive", (Exception)((Object)e));
            }
        } else {
            context.getLog().warn((CharSequence)("Could not generate archive classes file[" + targetFilename + "] has already been copied."));
        }
    }
}

