/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.doxia.module.xhtml.decoration.render;

import org.codehaus.doxia.module.xhtml.decoration.model.Item;
import org.codehaus.doxia.module.xhtml.decoration.model.Menu;
import org.codehaus.doxia.module.xhtml.decoration.render.DecorationRenderer;
import org.codehaus.doxia.module.xhtml.decoration.render.RenderingContext;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.xml.XMLWriter;

public class NavigationRenderer
implements DecorationRenderer {
    public void render(XMLWriter writer, RenderingContext renderingContext) {
        int menus = renderingContext.getDecorationModel().getMenus().size();
        for (int i = 0; i < menus; ++i) {
            Menu menu = (Menu)renderingContext.getDecorationModel().getMenus().get(i);
            writer.startElement("h5");
            writer.writeText(menu.getName());
            writer.endElement();
            int items = menu.getItems().size();
            writer.startElement("ul");
            for (int j = 0; j < items; ++j) {
                Item item = (Item)menu.getItems().get(j);
                this.writeMenuItem(item, writer, renderingContext);
            }
            writer.endElement();
        }
    }

    private void writeMenuItem(Item item, XMLWriter writer, RenderingContext renderingContext) {
        String href = item.getHref();
        String currentGroup = (String)renderingContext.getDecorationModel().getItemGroups().get(renderingContext.getOutputName());
        String collapse = item.isFoldable() ? (item.getGroup().equals(currentGroup) ? "expanded" : "collapsed") : "none";
        if (renderingContext.getOutputName().equals(href)) {
            writer.startElement("li");
            writer.addAttribute("class", collapse);
            writer.startElement("strong");
            writer.startElement("a");
            writer.addAttribute("href", PathTool.calculateLink((String)href, (String)renderingContext.getRelativePath()));
            writer.writeText(item.getName());
            writer.endElement();
            writer.endElement();
            writer.endElement();
        } else {
            writer.startElement("li");
            writer.addAttribute("class", collapse);
            writer.startElement("a");
            writer.addAttribute("href", PathTool.calculateLink((String)href, (String)renderingContext.getRelativePath()));
            writer.writeText(item.getName());
            writer.endElement();
            writer.endElement();
        }
        int count = item.getItems().size();
        for (int i = 0; i < count; ++i) {
            Item subitem = (Item)item.getItems().get(i);
            if (!subitem.getGroup().equals(currentGroup)) continue;
            writer.startElement("ul");
            this.writeMenuItem(subitem, writer, renderingContext);
            writer.endElement();
        }
    }
}

