package aQute.lib.osgi.header;

import java.util.*;

import aQute.lib.osgi.*;
import aQute.qtokens.*;

public class OSGiHeader {
	
	static public Map parseHeader(String value) {
		if (value == null || value.trim().length() == 0)
			return new HashMap();

		Map result = new LinkedHashMap();
		QuotedTokenizer qt = new QuotedTokenizer(value, ";=,");
		char del;
		do {
			boolean hadAttribute = false;
			Map clause = new HashMap();
			List aliases = new ArrayList();
			aliases.add(qt.nextToken());
			del = qt.getSeparator();
			while (del == ';') {
				String adname = qt.nextToken();
				if ((del = qt.getSeparator()) != '=') {
					if (hadAttribute)
						throw new IllegalArgumentException(
								"Header contains name field after attribute or directive: "
										+ adname + " from " + value);
					aliases.add(adname);
				} else {
					String advalue = qt.nextToken();
					clause.put(adname, advalue);
					del = qt.getSeparator();
					hadAttribute = true;
				}
			}
			for (Iterator i = aliases.iterator(); i.hasNext();) {
				String packageName = (String) i.next();
				if (result.containsKey(packageName)) {
					// TODO warnings
				} else
					result.put(packageName, clause);
			}
		} while (del == ',');
		return result;
	}

}
