package egovframework.rte.util.web.single.controllers;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.validation.BindException;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.support.StringMultipartFileEditor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;

import egovframework.rte.util.fileupload.single.service.StringFileUploadBean;

/**
 * @Class Name : StringFileUploadController.java
 * @Description : SingFileUpload StringFile을 TEST하기 위한 Class
 * @Modification Information
 * @
 * @  수정일         수정자                   수정내용
 * @ -------    --------    ---------------------------
 * @ 2009.03.05     이동도          최초 생성
 *
 *  @author 실행환경 개발팀 이동도
 *  @since 2009.03.05
 *  @version 1.0
 *  @see
 *  
 *  Copyright (C) 2009 by MOPAS  All right reserved.
 */

@Controller("stringFileUploadController")
public class StringFileUploadController{
    
	
	@RequestMapping(value = "/upload/stringFileSingle.do")
    protected String stringfileProcess(HttpServletRequest request, HttpServletResponse response, Object command
            ) throws Exception {
        
        /*
         * validate type of request and type of form backing object bean
         */
        Assert.state(request instanceof MultipartHttpServletRequest, "request !instanceof MultipartHttpServletRequest");
        Assert.state(command instanceof StringFileUploadBean, "command !instanceof StringFileUploadBean");
        
        /*
         * validate binding of text input field
         */
        StringFileUploadBean bean = (StringFileUploadBean) command;
        Assert.state(bean.getType().equals("stringFileSingle"), "type != stringFileSingle");
        
        /*
         * validate binding of uploaded file
         */
        String file = bean.getFile();
        Assert.notNull(file, "string file must not be null");
        
        return stringfileProcess(request, response, command);
    }
    
    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws ServletException {
        binder.registerCustomEditor(String.class, new StringMultipartFileEditor());
    }
    
}