/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ResultSetAccessor;
import oracle.jdbc.driver.T2CConnection;

class T2CResultSetAccessor
extends ResultSetAccessor {
    T2CResultSetAccessor(OracleStatement oracleStatement, int n, short s, int n2, boolean bl) throws SQLException {
        super(oracleStatement, n * 2, s, n2, bl);
    }

    T2CResultSetAccessor(OracleStatement oracleStatement, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, short s) throws SQLException {
        super(oracleStatement, n * 2, bl, n2, n3, n4, n5, n6, s);
    }

    byte[] getBytes(int n) throws SQLException {
        byte[] byArray = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            short s = this.rowSpaceIndicator[this.lengthIndex + n];
            byte by = ((T2CConnection)this.statement.connection).byteAlign;
            int n2 = this.columnIndex + (by - 1) & ~(by - 1);
            int n3 = n2 + s * n;
            byArray = new byte[s];
            System.arraycopy(this.rowSpaceByte, n3, byArray, 0, s);
        }
        return byArray;
    }
}

