/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringBufferInputStream;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;

public class OracleSerialClob
implements Clob,
Serializable,
Cloneable {
    private char[] buffer;
    private long length;

    public OracleSerialClob(char[] cArray) throws SQLException {
        this.length = cArray.length;
        this.buffer = new char[(int)this.length];
        int n = 0;
        while ((long)n < this.length) {
            this.buffer[n] = cArray[n];
            ++n;
        }
    }

    public OracleSerialClob(Clob clob) throws SQLException {
        this.length = clob.length();
        this.buffer = new char[(int)this.length];
        BufferedReader bufferedReader = new BufferedReader(clob.getCharacterStream());
        try {
            int n = 0;
            int n2 = 0;
            do {
                n = bufferedReader.read(this.buffer, n2, (int)(this.length - (long)n2));
                n2 += n;
            } while (n > 0);
        }
        catch (IOException iOException) {
            throw new SQLException("SerialClob: " + iOException.getMessage());
        }
    }

    public InputStream getAsciiStream() throws SQLException {
        return new StringBufferInputStream(new String(this.buffer));
    }

    public Reader getCharacterStream() throws SQLException {
        return new CharArrayReader(this.buffer);
    }

    public String getSubString(long l, int n) throws SQLException {
        if (l < 0L || (long)n > this.length || l + (long)n > this.length) {
            throw new SQLException("Invalid Arguments");
        }
        return new String(this.buffer, (int)l, n);
    }

    public long length() throws SQLException {
        return this.length;
    }

    public long position(String string, long l) throws SQLException {
        if (l < 0L || l > this.length || l + (long)string.length() > this.length) {
            throw new SQLException("Invalid Arguments");
        }
        char[] cArray = string.toCharArray();
        int n = (int)(l - 1L);
        boolean bl = false;
        long l2 = cArray.length;
        if (l < 0L || l > this.length) {
            return -1L;
        }
        while ((long)n < this.length) {
            int n2 = 0;
            long l3 = n + 1;
            while (cArray[n2++] == this.buffer[n++]) {
                if ((long)n2 != l2) continue;
                return l3;
            }
        }
        return -1L;
    }

    public long position(Clob clob, long l) throws SQLException {
        return this.position(clob.getSubString(0L, (int)clob.length()), l);
    }

    public int setString(long l, String string) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    public int setString(long l, String string, int n, int n2) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    public OutputStream setAsciiStream(long l) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public Writer setCharacterStream(long l) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public void truncate(long l) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
    }
}

